import { uniqueCheck, uniqueCheck2 } from "./checkDuplicate";

export const manageFilter = (filterableAttributes, url, filter_applied) => {
    let query = url?.split("?");
    if (query?.length == 2) {
        filterAppliedProperty = [...new Set(query[1].split("&").slice(2))];
    }
    let attr = {};
    let Attr = [];
    let rating;
    let price_range;

    let filterableAttributesKey = Object.keys(filterableAttributes);
    let categoryHaveSlug =
        filterableAttributesKey.includes("categories") &&
        filterableAttributesKey.includes("category_slug");

    for (let key in filterableAttributes) {
        let arr = [];
        let keyTypeObject = typeof filterableAttributes[key] == "object";
        let keyIsArray = Array.isArray(filterableAttributes[key]);
        let arrayLength = 0;
        if (keyIsArray) {
            arrayLength = filterableAttributes[key].length;
        }
        if (key == "price_range") {
            price_range = filterableAttributes[key];
        } else {
            if (
                key == "categories" &&
                keyIsArray &&
                arrayLength > 0 &&
                categoryHaveSlug
            ) {
                filterableAttributes[key].forEach((item, index) => {
                    arr.push({
                        name: item,
                        slug: filterableAttributes["category_slug"][index],
                    });
                });
                attr[key] = {
                    attribute: false,
                    status: false,
                    value: arr.map(uniqueCheck.bind(null, filter_applied[key] ?? [])),
                };
            } else if (
                filterableAttributes[key] != null &&
                key != "category_slug"
            ) {
                if (
                    keyTypeObject &&
                    keyIsArray &&
                    Object.keys(filterableAttributes[key]).length > 0
                ) {
                    attr[key] = {
                        attribute: false,
                        status: false,
                        value: filterableAttributes[key].map(uniqueCheck.bind(null, filter_applied[key] ?? [])),
                    };
                } else if (
                    keyTypeObject &&
                    !keyIsArray &&
                    Object.keys(filterableAttributes[key]).length > 0
                ) {
                    for (let item in filterableAttributes[key]) {
                        if (
                            Array.isArray(filterableAttributes[key][item]) &&
                            Object.keys(filterableAttributes[key][item])
                                .length > 0
                        ) {
                            attr[item] = {
                                attribute: true,
                                status: false,
                                value: filterableAttributes[key][item].map(
                                    uniqueCheck.bind(null, filter_applied[key][item] ?? [])
                                ),
                            };
                        } else if (
                            typeof filterableAttributes[key][item] ===
                                "object" &&
                            !Array.isArray(filterableAttributes[key][item])
                        ) {
                            attr[item] = {
                                attribute: true,
                                status: false,
                                value: Object.keys(
                                    filterableAttributes[key][item]
                                ).map(uniqueCheck2.bind(null, filter_applied[key][item] ?? [], filterableAttributes[key][item])),
                            };
                        }
                    }
                }

                if (typeof filterableAttributes[key] == "number") {
                    rating = filterableAttributes[key];
                }
            }
        }
    }
    Attr.push(attr);
    let prop = Attr.reduce((acc, obj) => {
        Object.keys(obj).forEach((key) => {
            let isCheckedValue = obj[key]?.value.map(item => item.isChecked);
            if(isCheckedValue?.includes(true)) {
                obj[key].status = true
            }
            acc.push({ [key]: obj[key] });
        });
        return acc;
    }, []);
    return { prop, price_range, rating };
};
